import oracle.sqlj.runtime.Oracle;
import sqlj.runtime.ref.DefaultContext;
import sqlj.runtime.ExecutionContext;
import sqlj.runtime.ResultSetIterator;
import java.sql.*;
import java.io.*;
import java.util.Date;
import oracle.jdbc.*;
import oracle.jdbc.oracore.*;
import oracle.sql.*;
import java.lang.reflect.*;
import java.math.BigDecimal;

public class TestInh
{
  private static oracle.jdbc.OracleConnection conn = null;
  public static void main(String argv[]) throws SQLException
  {
    java.sql.DriverManager.registerDriver(new oracle.jdbc.OracleDriver());
    conn = (oracle.jdbc.OracleConnection) 
    java.sql.DriverManager.getConnection("jdbc:oracle:oci8:@", "scott", "tiger");
    try
    {
      // init(); // Required by JPub 9.0.1. Not needed in JPub 9.0.2 or later
      
      InhPerson jerry = new InhPerson();
      jerry.setName("Jerry X.");
      jerry.setDob(new java.sql.Timestamp(System.currentTimeMillis()));
      jerry.setSsn(new java.math.BigDecimal(1002));

      InhStudent george = new InhStudent();
      george.setName("George X.");
      george.setDob(new java.sql.Timestamp(System.currentTimeMillis()));
      george.setSsn(new java.math.BigDecimal(1202));
      george.setDeptid(new java.math.BigDecimal(14));
      george.setMajor("Chemistry");
    
      InhGraduate robert = new InhGraduate();
      robert.setSsn(new java.math.BigDecimal(1222));
      robert.setName("Robert X.");
      robert.setDob(new java.sql.Timestamp(System.currentTimeMillis()));
      robert.setDeptid(new java.math.BigDecimal(16));
      robert.setMajor("Biology");
      robert.setHours(new java.math.BigDecimal(30));

      deleteFrom(new String[] {"PERSON_TAB", "STUDENT_TAB", "GRADUATESTUDENT_TAB"});

      insert("PERSON_TAB", new InhPerson[]{ jerry, george, robert });
      select("PERSON_TAB");

      insert("STUDENT_TAB", new InhStudent[] { george, robert });
      select("STUDENT_TAB");

      insert("GRADUATESTUDENT_TAB", new InhGraduate[] { robert });
      select("GRADUATESTUDENT_TAB");
    }
    finally
    {
      conn.close();
    }
  }


  private static void init() throws SQLException
  {
    System.out.println ("Initialize Classes");
   
    new InhPerson();          // can be omitted
    new InhStudent();         // can be omitted
    new InhGraduate(); // required - this is a leaf type
  }


  private static void deleteFrom(String[] tabs) throws SQLException
  {
    for (int i=0; i<tabs.length; i++)
    {
      PreparedStatement stmt = conn.prepareStatement("delete from " + tabs[i]);
      stmt.executeUpdate();
    }
  }

  private static void select(String table) throws SQLException
  {
    System.out.println ("List the values selected from "+table+"");

    PreparedStatement stmt = conn.prepareStatement("select value(p) as pers from " + table + " p");
    ResultSet rs = stmt.executeQuery();
    while (rs.next())
    {
      System.out.println(getPersonInfo((InhPerson)((OracleResultSet)rs).getORAData(1, InhPerson.getORADataFactory())));  
    }
    rs.close();
  }

  private static void insert(String table, InhPerson[] persons) throws SQLException
  {
    for (int i=0; i<persons.length; i++)
    {
      // Change initial X. to P. or S. or G.
      String name = persons[i].getName();
      name = name.substring(0,name.length()-2) + table.substring(0,1) + ".";
      persons[i].setName(name);

      System.out.println("Insert "+persons[i].getClass().getName()+" "+
                         name+" into "+table);
      PreparedStatement stmt = conn.prepareStatement("insert into " + table + " values(:1)");
      ((OraclePreparedStatement) stmt).setORAData(1, persons[i]);
      stmt.executeUpdate();
    }
  }

  private static String getPersonInfo(InhPerson person) throws SQLException
  {
    if (person instanceof InhGraduate)
    {
      return "GRADUATESTUDENT: " + getGraduateInfo((InhGraduate)person);
    }
    else if (person instanceof InhStudent)
    {
      return "STUDENT: " +getStudentInfo((InhStudent)person);
    }
    else  
    {
      return "PERSON: " + getBasePersonInfo(person); 
    }
  }

  private static String getBasePersonInfo(InhPerson person) throws SQLException
  {
    return person.getSsn() + ", " + person.getName();
  }

  private static String getStudentInfo(InhStudent student) throws SQLException
  {
    return getBasePersonInfo(student) + ", " + student.getMajor();
  }
  
  private static String getGraduateInfo(InhGraduate grad) throws SQLException
  {
    return getStudentInfo(grad) + ", " + grad.getHours();
  }
}

